import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {graphql, compose} from "react-apollo";
import gql from "graphql-tag";
import {Form, TextArea} from 'react-form';
import InterventoForm from "../../../../core/Forms/InterventoForm/InterventoForm";
import {authUserQuery, interventoQuery} from "../../../../api/queries";
import {findById} from "../../../../utils";
import Loading from "../../../../core/Loading/Loading";

class Edit extends Component {

    constructor(props) {
        super(props);

        this.state = {
            submitting: false,
            error: false,
        };
    }

    render() {
        const {
            data,
            utenteSessione
        } = this.props;

        if(data.loading) {
            return (<Loading/>);
        }

        return (<div className="container" style={{marginBottom: '20px'}}>
            <h1>Salva intervento</h1>
            <InterventoForm
                data={data}
                utenteSessione={utenteSessione}
                submitMutation={gql`
                    mutation($intervento: InterventoInput) {
                        updateIntervento(intervento: $intervento) {
                            id
                        }
                    }`} />
        </div>);
    }
}

export default compose(
    graphql(interventoQuery, {
        options:({match}) => ({variables: {id: match.params.id}}),
    }),
    graphql(authUserQuery, {name: 'utenteSessione'})
)(Edit);

Edit.defaultProps = {};

Edit.propTypes = {};